#include "vector4.h"

void genTesseract (Object *o, double size, double p, Vector3 rot, Vector3 camPos) {
    Vector3 dir = V3setmag(V3sub(o->position, camPos), size * p / 2);
    dir.x -= dir.x / 2; dir.y -= dir.y / 2; dir.z -= dir.z / 2;
    dir = V3unrotate(dir, o->rotation);

    Line* lines;
    if (sizeof(o->model.lines) != sizeof(Line) * 32)
        lines = (Line*)malloc(sizeof(Line) * 32);
    else
        lines = o->model.lines;

    int l = 0;
    for (int a = 0; a < 4; a++) {
        double a1 = (a / 2.0 + 0.25) * PI;        // + rot
        double a2 = ((a + 1) / 2.0 + 0.25) * PI;  // + rot

        for (int q = 0; q < 4; q++) {
            double q1 = (q / 2.0 + 0.25) * PI;
            double q2 = ((q + 1) / 2.0 + 0.25) * PI;

            /*
            // Fake perspective, points rotate around a cube's corners
            lines[l++] = genLine(cos(q1) * (sin(a1) * p + 1) * size, sin(q1) * (sin(a1) * p + 1) * size, cos(a1) * size,
                                 cos(q2) * (sin(a1) * p + 1) * size, sin(q2) * (sin(a1) * p + 1) * size, cos(a1) * size);
            lines[l++] = genLine(cos(q1) * (sin(a1) * p + 1) * size, sin(q1) * (sin(a1) * p + 1) * size, cos(a1) * size,
                                 cos(q1) * (sin(a2) * p + 1) * size, sin(q1) * (sin(a2) * p + 1) * size, cos(a2) * size);
            */

            /*
            // Calculated perspective further from camera, rotation around Z/W
            lines[l++] = genLine(cos(q1) * size + (sin(a1) + 1) * dir.x, sin(q1) * size + (sin(a1) + 1) * dir.y, cos(a1) * size + (sin(a1) + 1) * dir.z,
                                 cos(q2) * size + (sin(a1) + 1) * dir.x, sin(q2) * size + (sin(a1) + 1) * dir.y, cos(a1) * size + (sin(a1) + 1) * dir.z);
            lines[l++] = genLine(cos(q1) * size + (sin(a1) + 1) * dir.x, sin(q1) * size + (sin(a1) + 1) * dir.y, cos(a1) * size + (sin(a1) + 1) * dir.z,
                                 cos(q1) * size + (sin(a2) + 1) * dir.x, sin(q1) * size + (sin(a2) + 1) * dir.y, cos(a2) * size + (sin(a2) + 1) * dir.z);
            */

            // Calculated same as above, but along all axes
            Vector4 c11 = V4(cos(q1) * size, sin(q1) * size, cos(a1) * size, sin(a1) * size);
            Vector4 c12 = V4(cos(q2) * size, sin(q2) * size, cos(a1) * size, sin(a1) * size);
            Vector4 c21 = V4(cos(q1) * size, sin(q1) * size, cos(a2) * size, sin(a2) * size);
            c11 = V4rotate(c11, rot);
            c12 = V4rotate(c12, rot);
            c21 = V4rotate(c21, rot);
            lines[l++] = genLine(c11.x + dir.x * c11.w, c11.y + dir.y * c11.w, c11.z + dir.z * c11.w,
                                 c12.x + dir.x * c12.w, c12.y + dir.y * c12.w, c12.z + dir.z * c12.w);
            lines[l++] = genLine(c11.x + dir.x * c11.w, c11.y + dir.y * c11.w, c11.z + dir.z * c11.w,
                                 c21.x + dir.x * c21.w, c21.y + dir.y * c21.w, c21.z + dir.z * c21.w);
        }
    }

    o->model.lines = lines;
    o->model.linec = 32;
}
