#include "vector3.h"

#define PI 3.14159265

typedef struct { Vector3 start, end; } Line;
typedef struct { int linec; Line* lines; } Model;
typedef struct { Vector3 position, rotation; Model model; double shade; } Object;

Line genLine (double x1, double y1, double z1, double x2, double y2, double z2) {
    Line l;
    l.start = V3(x1, y1, z1);
    l.end = V3(x2, y2, z2);
    return l;
}

void genCube (Object* o, double sizeX, double sizeY, double sizeZ) {
    Line* lines = (Line*)malloc(sizeof(Line) * 12);

    // Get 4 corners diagonal to each other, then connect them to the 3 corners they're each adjacent to
    int l = 0;
    for (int sx = -1; sx < 2; sx += 2) {
        for (int sy = -1; sy < 2; sy += 2) {
            for (int c = 0; c < 3; c++) {
                int cx = c == 0 ? -1 : 1;
                int cy = c == 1 ? -1 : 1;
                int cz = c == 2 ? -1 : 1;
                lines[l++] = genLine(sx * sizeX, sy * sizeY, sx * sy * sizeZ,
                                     sx * cx * sizeX, sy * cy * sizeY, sx * sy * cz * sizeZ);
            }
        }
    }

    o->model.lines = lines;
    o->model.linec = 12;
}

void genRect (Object* o, double sizeX, double sizeY, double over) {
    over = over + 1;
    Line* lines = (Line*)malloc(sizeof(Line) * 4);
    lines[0] = genLine(-sizeX * over, -sizeY, 0, sizeX * over, -sizeY, 0);
    lines[1] = genLine(sizeX, -sizeY * over, 0, sizeX, sizeY * over, 0);
    lines[2] = genLine(sizeX * over, sizeY, 0, -sizeX * over, sizeY, 0);
    lines[3] = genLine(-sizeX, sizeY * over, 0, -sizeX, -sizeY * over, 0);

    o->model.lines = lines;
    o->model.linec = 4;
}
