typedef struct { double x, y, z, w; } Vector4;

Vector4 V4 (double x, double y, double z, double w) {
    Vector4 v;
    v.x = x;
    v.y = y;
    v.z = z;
    v.w = w;
    return v;
}

Vector4 V3toV4 (Vector3 v3) {
    return V4(v3.x, v3.y, v3.z, 0);
}

Vector4 V4add (Vector4 a, Vector4 b) {
    return V4(a.x + b.x, a.y + b.y, a.z + b.z, a.w + b.w);
}

void V4addTo (Vector4* a, Vector4* b) {
    a->x += b->x;
    a->y += b->y;
    a->z += b->z;
    a->w += b->w;
}

Vector4 V4sub (Vector4 a, Vector4 b) {
    return V4(a.x - b.x, a.y - b.y, a.z - b.z, a.w - b.w);
}

Vector4 V4mul (Vector4 a, double b) {
    return V4(a.x * b, a.y * b, a.z * b, a.w * b);
}

void V4mulTo (Vector4* a, double b) {
    a->x *= b;
    a->y *= b;
    a->z *= b;
    a->w *= b;
}

Vector4 V4div (Vector4 a, double b) {
    return (b != 0 ? V4mul(a, 1 / b) : V4(0, 0, 0, 0));
}

double V4mag (Vector4 a) {
    return sqrt(a.x * a.x + a.y * a.y + a.z * a.z + a.w * a.w);
}

Vector4 V4setmag (Vector4 a, double b) {
    Vector4 norm = V4div(a, V4mag(a));
    return V4mul(norm, b);
}

/*
Vector4 V4rotateX (Vector4 a, double b) {
    double angle = atan2(a.y, a.z) + b;
    double mag = sqrt(a.y * a.y + a.z * a.z);
    return V4(a.x, sin(angle) * mag, cos(angle) * mag, a.w);
}


Vector4 V4rotateY (Vector4 a, double b) {
    double angle = atan2(a.x, a.z) + b;
    double mag = sqrt(a.x * a.x + a.z * a.z);
    return V4(sin(angle) * mag, a.y, cos(angle) * mag, a.w);
}


Vector4 V4rotateZ (Vector4 a, double b) {
    double angle = atan2(a.x, a.y) + b;
    double mag = sqrt(a.x * a.x + a.y * a.y);
    return V4(sin(angle) * mag, cos(angle) * mag, a.z, a.w);
}
*/

Vector4 V4rotateXW (Vector4 a, double b) {
    double angle = atan2(a.x, a.w) + b;
    double mag = sqrt(a.x * a.x + a.w * a.w);
    return V4(sin(angle) * mag, a.y, a.z, cos(angle) * mag);
}

Vector4 V4rotateYW (Vector4 a, double b) {
    double angle = atan2(a.y, a.w) + b;
    double mag = sqrt(a.y * a.y + a.w * a.w);
    return V4(a.x, sin(angle) * mag, a.z, cos(angle) * mag);
}


Vector4 V4rotateZW (Vector4 a, double b) {
    double angle = atan2(a.z, a.w) + b;
    double mag = sqrt(a.z * a.z + a.w * a.w);
    return V4(a.x, a.y, sin(angle) * mag, cos(angle) * mag);
}

Vector4 V4rotate (Vector4 a, Vector3 c) {
    return V4rotateXW(V4rotateYW(V4rotateZW(a, c.z), c.y), c.x);
    // return V4rotateX(V4rotateY(V4rotateZ(a, b.z), b.y), b.x);
}

Vector4 V4unrotate (Vector4 a, Vector3 b, Vector3 c) {
    // Vector4 v = V3rotateZ(V3rotateY(V3rotateX(a, -b.x), -b.y), -b.z);
    return V4rotateZW(V4rotateYW(V4rotateXW(a, -c.x), -c.y), -c.z);
}

Vector4 V4lerp (Vector4 a, Vector4 b, double c) {
    return V4(a.x * c + b.x * (1 - c), a.y * c + b.y * (1 - c), a.z * c + b.z * (1 - c), a.w * c + b.w * (1 - c));
}

void V4print (int y, int x, Vector4 a) {
    mvprintw(y, x, "V4(%.2f, %.2f, %.2f, %.2f)\n", a.x, a.y, a.z, a.w);
}
