typedef struct { double x, y, z; } Vector3;

Vector3 V3 (double x, double y, double z) {
    Vector3 v;
    v.x = x;
    v.y = y;
    v.z = z;
    return v;
}

Vector3 V3add (Vector3 a, Vector3 b) {
    return V3(a.x + b.x, a.y + b.y, a.z + b.z);
}

void V3addTo (Vector3* a, Vector3* b) {
    a->x += b->x;
    a->y += b->y;
    a->z += b->z;
}

Vector3 V3sub (Vector3 a, Vector3 b) {
    return V3(a.x - b.x, a.y - b.y, a.z - b.z);
}

Vector3 V3mul (Vector3 a, double b) {
    return V3(a.x * b, a.y * b, a.z * b);
}

void V3mulTo (Vector3* a, double b) {
    a->x *= b;
    a->y *= b;
    a->z *= b;
}

Vector3 V3div (Vector3 a, double b) {
    return (b != 0 ? V3mul(a, 1 / b) : V3(0, 0, 0));
}

double V3mag (Vector3 a) {
    return sqrt(a.x * a.x + a.y * a.y + a.z * a.z);
}

Vector3 V3setmag (Vector3 a, double b) {
    Vector3 norm = V3div(a, V3mag(a));
    return V3mul(norm, b);
}


Vector3 V3rotateX (Vector3 a, double b) {
    double angle = atan2(a.y, a.z) + b;
    double mag = sqrt(a.y * a.y + a.z * a.z);
    return V3(a.x, sin(angle) * mag, cos(angle) * mag);
}


Vector3 V3rotateY (Vector3 a, double b) {
    double angle = atan2(a.x, a.z) + b;
    double mag = sqrt(a.x * a.x + a.z * a.z);
    return V3(sin(angle) * mag, a.y, cos(angle) * mag);
}


Vector3 V3rotateZ (Vector3 a, double b) {
    double angle = atan2(a.x, a.y) + b;
    double mag = sqrt(a.x * a.x + a.y * a.y);
    return V3(sin(angle) * mag, cos(angle) * mag, a.z);
}

Vector3 V3rotate (Vector3 a, Vector3 b) {
    return V3rotateZ(V3rotateY(V3rotateX(a, b.x), b.y), b.z);
}

Vector3 V3unrotate (Vector3 a, Vector3 b) {
    return V3rotateX(V3rotateY(V3rotateZ(a, -b.z), -b.y), -b.x);
}

Vector3 V3lerp (Vector3 a, Vector3 b, double c) {
    return V3(a.x * c + b.x * (1 - c), a.y * c + b.y * (1 - c), a.z * c + b.z * (1 - c));
}

void V3print (int y, int x, Vector3 a) {
    mvprintw(y, x, "V3(%f, %f, %f)\n", round(a.x * 100) / 100, round(a.y * 100) / 100, round(a.z * 100) / 100);
}
