#include "worldobject.h"

#define shadeFunc(z) shadec - shadec * pow(1.1, -z)

double perspective = 1.2;
double clip = 0.5;

char shades[] = {'@', '#', '%', '&', '$', '=', '*', '~', '-', ',', '.', '`'};
int shadec = 12;

struct winsize w;

Vector3 mapToScreen (Vector3 point) {
    // point.x /= sqrt(point.x * point.x + point.z * point.z);
    // point.y /= sqrt(point.y * point.y + point.z * point.z);
    double pPower = 1 / (point.z + clip);
    point.x *= pPower; point.y *= pPower;
    return V3((point.x / perspective / 2 * w.ws_col + w.ws_col) / 2, (point.y / perspective * w.ws_row + w.ws_row) / 2, point.z);
}

Vector3 calcRelative (Vector3 point, Vector3 camPos, Vector3 camRot) {
    return V3unrotate(V3sub(point, camPos), camRot);
}

void drawLine (Vector3 a, Vector3 b, double shade, Vector3 camPos, Vector3 camRot) {
    Vector3 am = calcRelative(a, camPos, camRot);
    Vector3 bm = calcRelative(b, camPos, camRot);

    /*
       [A]            \          \
        |\             | ratio    |
        | \            | A->clip  | length
     ~~~|~~\~~~ clip  /           | A->B
        B   B                    /

    Straight ratio = Diagonal ratio
    Calculate straight ratio & lerp diagonally
    */
    if (am.z < clip && bm.z < clip) return;
    if (am.z < clip) {
        double ratio = (am.z - clip) / (am.z - bm.z);
        am = V3lerp(bm, am, ratio);
    } else if (bm.z < clip) {
        double ratio = (bm.z - clip) / (bm.z - am.z);
        bm = V3lerp(am, bm, ratio);
    }

    am = mapToScreen(am);
    bm = mapToScreen(bm);

    if (am.x < 0 && bm.x < 0 || am.x > w.ws_col && bm.x > w.ws_col
     || am.y < 0 && bm.y < 0 || am.y > w.ws_row && bm.y > w.ws_row) return;

    Vector3 drawing = am;
    double mag = sqrt((am.x - bm.x) * (am.x - bm.x) + (am.y - bm.y) * (am.y - bm.y));
    Vector3 dir = V3((bm.x - am.x) / mag, (bm.y - am.y) / mag, (bm.z - am.z) / mag);

    for (int n = 0; n < mag; n++) {

        mvprintw((int)drawing.y, (int)drawing.x, "%c", shades[(int)(shadeFunc(drawing.z * shade))]);
        V3addTo(&drawing, &dir);
    }
}

void drawPerspectiveModel (Object object, Vector3 camPos, Vector3 camRot) {
    for (int l = 0; l < object.model.linec; l++) {
        Vector3 start = V3add(V3rotate(object.model.lines[l].start, object.rotation), object.position);
        Vector3 end = V3add(V3rotate(object.model.lines[l].end, object.rotation), object.position);
        drawLine(start, end, object.shade, camPos, camRot);
    }
}

void init () {
    initscr();
    noecho();
    curs_set(FALSE);
    nodelay(stdscr, TRUE);

    ioctl(STDOUT_FILENO, TIOCGWINSZ, &w);
    // mvprintw(0, 0, "Width: %d\n", w.ws_col);
    // mvprintw(1, 0, "Height: %d\n", w.ws_row);
}

void uninit () {
    curs_set(TRUE);
}
