#include "deps.h"
#include "engine.h"
#include "worldobject4.h"

const double skip = 2;

double moveSpeed = 0.2 * skip;
double lookSpeed = 0.03 * skip;
double moveDrag = 1 - 0.05 * skip;
double lookDrag = 1 - 0.05 * skip;
double accelLerp = 0.2;

double mod (double a, double b) {
    while (a < 0) a += b;
    while (a >= b) a -= b;
    return a;
}

int main (int arg, char* argv[]) {    
    init();
    Vector3 pos, rot, posMom, rotMom;
    pos = V3(0, 0, 0); rot = V3(0, 0, 0);
    posMom = V3(0, 0, 0); rotMom = V3(0, 0, 0);

    Object sqre;
    sqre.position = V3(-13, 0, 6.5);
    sqre.rotation = V3(0, 0, 0);
    sqre.shade = 1;
    genRect(&sqre, 3, 3, 0);

    Object cube;
    cube.position = V3(0, 0, 6.5);
    cube.rotation = V3(0, 0, 0);
    cube.shade = 1;
    genCube(&cube, 3, 3, 3);

    Object tess;
    tess.position = V3(13, 0, 6.5);
    tess.rotation = V3(0, 0, 0);
    tess.shade = 1;

    Object floor;
    floor.position = V3(0, 3, 0);
    floor.rotation = V3(PI / 2, 0, 0);
    floor.shade = 3;
    genRect(&floor, 3, 3, 2);

    bool spin = true;
    int n = 0;
    while (TRUE) {
        clear();

        // pos = cube.position;
        // rot = V3(cube.rotation.x, cube.rotation.y, cube.rotation.z);

        genTesseract(&tess, 3, 2, V3(n * 0.01, n * 0.01, n * 0.01), pos);
        drawPerspectiveModel(floor, V3(mod(pos.x - 3, 6) - 3, pos.y, mod(pos.z - 3, 6) - 3), rot);
        drawPerspectiveModel(tess, pos, rot);
        drawPerspectiveModel(cube, pos, rot);
        drawPerspectiveModel(sqre, pos, rot);

        // o.rotation.x += 0.001;
        // tess.rotation.y += 0.0081;
        // tess.rotation.z += 0.003;
        if (spin) {
            n += skip;
            cube.rotation.y += 0.01 * skip;
            cube.rotation.x += 0.003 * skip;
            sqre.rotation.z += 0.013 * skip;
        }
        // o.rotation.y += 0.003;

        V3print(1, 1, pos);

        switch (getch()) {
            case 'w':
                posMom.x = posMom.x * (1 - accelLerp) + sin(rot.y) * moveSpeed * accelLerp;
                posMom.z = posMom.z * (1 - accelLerp) + cos(rot.y) * moveSpeed * accelLerp;
                break;
            case 's':
                posMom.x = posMom.x * (1 - accelLerp) + -sin(rot.y) * moveSpeed * accelLerp;
                posMom.z = posMom.z * (1 - accelLerp) + -cos(rot.y) * moveSpeed * accelLerp;
                break;
            case 'a':
                posMom.x = posMom.x * (1 - accelLerp) + -cos(rot.y) * moveSpeed * accelLerp;
                posMom.z = posMom.z * (1 - accelLerp) + sin(rot.y) * moveSpeed * accelLerp;
                break;
            case 'd':
                posMom.x = posMom.x * (1 - accelLerp) + cos(rot.y) * moveSpeed * accelLerp;
                posMom.z = posMom.z * (1 - accelLerp) + -sin(rot.y) * moveSpeed * accelLerp;
                break;
            case 'e':
                posMom.y = posMom.y * (1 - accelLerp) + -moveSpeed * accelLerp;
                break;
            case 'q':
                posMom.y = posMom.y * (1 - accelLerp) + moveSpeed * accelLerp;
                break;

            case 'k':
                rotMom.x = rotMom.x * (1 - accelLerp) + -lookSpeed * accelLerp;
                break;
            case 'j':
                rotMom.x = rotMom.x * (1 - accelLerp) + lookSpeed * accelLerp;
                break;
            case 'h':
                rotMom.y = rotMom.y * (1 - accelLerp) + -lookSpeed * accelLerp;
                break;
            case 'l':
                rotMom.y = rotMom.y * (1 - accelLerp) + lookSpeed * accelLerp;
                break;
            case 'p':
                spin = !spin;
                break;
        }

        V3addTo(&pos, &posMom);
        V3addTo(&rot, &rotMom);
        V3mulTo(&posMom, moveDrag);
        V3mulTo(&rotMom, lookDrag);

        usleep(10000 * skip);
    }
    uninit();
}
