class Ufo implements Physics {
    PVector pos, vel, velTarget, avoid;
    float rot, spin, spinThrust;
    float thrust, reload;

    Ufo(PVector pos, PVector vel) {
        this.pos = pos;
        this.vel = vel;
        this.rot = 0.0;
        this.spin = random(10.0) - 5.0;
        this.spinThrust = 0.0;
        this.reload = 5.0;
        this.velTarget = new PVector(0.0, 0.0);
        this.avoid = new PVector(0.0, 0.0);
    }
    
    PVector pos() {
        return this.pos;
    }
    PVector vel() {
        return this.vel;
    }
    float radius() {
        return 0.07;
    }
    float mass() {
        return 0.03;
    }
    void collision(Physics other, float speed, float massToOther, int which) {
        this.spin += (random(10.0) - 5.0) * sqrt(abs(speed));
    }
    void collideEarth(Earth e, float speed) {
        circleParticles(e.pos, new PVector(0.0, 0.0), 0.075, 24, new PVector(0x00, 0x7f, 0xff));
        e.life += 1.0;
        ufo = null;
    }

    void move(PVector gravity) {
        PVector toEarth = PVector.sub(gravity, this.pos);

        PVector avoidMeteor = new PVector(0.0, 0.0);
        for (int m = 0; m < meteors.size(); m++) {
            Meteor meteor = meteors.get(m);
            PVector toUfo = PVector.sub(this.pos, meteor.pos);
            if (toUfo.mag() > 0.5) continue;
            toUfo.normalize();
            PVector avgVel = PVector.sub(meteor.vel, this.vel);
            float speed = avgVel.dot(toUfo);
            if (speed < 0.0) continue;
            PVector fromMeteor = PVector.sub(this.pos, meteor.pos);
            fromMeteor.setMag(speed * (meteor.size + 0.5) * 0.5);
            avoidMeteor.add(fromMeteor);
        }
        this.avoid.lerp(avoidMeteor, delta * 5.0);

        PVector up = PVector.fromAngle(this.rot);
        
        float toTargetAngle = min(max(up.cross(velTarget).z, -1.0), 1.0);
        /*
        float toTargetAngle = this.rot - velTarget.heading() - PI;
        if (abs(toTargetAngle) > abs(toTargetAngle - TWO_PI)) toTargetAngle -= TWO_PI;
        else if (abs(toTargetAngle) > abs(toTargetAngle + TWO_PI)) toTargetAngle += TWO_PI;
        */

        this.spinThrust = absSqrt(toTargetAngle, 1.0) * 6.0 * delta;
        this.spin += this.spinThrust;
        this.spin *= 0.985;
        this.rot += this.spin * delta;
        while (this.rot < 0.0) this.rot += TWO_PI;
        this.rot %= TWO_PI;

        //float distThrust = max(pow(0.6 - toEarth.mag(), 2.0), 0.1);
        PVector dirToEarth = toEarth.copy();
        dirToEarth.normalize();
        float velToEarth = this.vel.dot(dirToEarth);
        float distThrust = 0.1 / max(toEarth.mag() - velToEarth * 0.1 - 0.2, 0.05);
        this.velTarget = PVector.mult(dirToEarth, -distThrust);
        this.velTarget.add(this.avoid);

        float targetToEarth = this.velTarget.dot(dirToEarth);
        if (targetToEarth >= 0.0) {
            this.velTarget.sub(PVector.mult(dirToEarth, targetToEarth));
        }
        this.thrust = min(sqrt(max(up.dot(this.velTarget) + 0.2, 0.0)) * this.velTarget.mag(), 1.5);

        this.vel.add(PVector.mult(up, this.thrust * 10.0 * delta));

        PVector accel = toEarth.copy();
        accel.setMag(5.0 * delta);
        this.vel.add(accel);
        if (this.vel.mag() > 10.0) {
            this.vel.mult(0.99);
        }

        this.pos.add(PVector.mult(this.vel, physicsSpeed[difficulty] * delta));
    }

    void draw() {
        pushMatrix();
        translate(this.pos.x * viewScale, this.pos.y * viewScale);

        //stroke(0x00, 0x7f, 0xff);
        //ellipse(0.0, 0.0, 0.14 * viewScale, 0.14 * viewScale);
        //ellipse(this.velTarget.x * viewScale, this.velTarget.y * viewScale, 20, 20);
        //line(0.0, 0.0, this.velTarget.x * viewScale, this.velTarget.y * viewScale);
        //noStroke();
        
        rotate(this.rot + HALF_PI);
        fill(0x00, 0x7f, 0xff);
        ellipse(0.0, -0.03 * viewScale, 0.05 * viewScale, 0.05 * viewScale);
        
        float fillLeft = max(this.thrust + this.spinThrust, 0.0) * 0.5 + 0.5;
        fill(0.00, 0x7f * fillLeft, 0xff * fillLeft);
        ellipse(-0.06 * viewScale, 0.03 * viewScale, 0.02 * viewScale, 0.02 * viewScale);
        float fillRight = max(this.thrust - this.spinThrust, 0.0) * 0.5 + 0.5;
        fill(0.00, 0x7f * fillRight, 0xff * fillRight);
        ellipse(0.06 * viewScale, 0.03 * viewScale, 0.02 * viewScale, 0.02 * viewScale);
        
        fill(0x7f);
        ellipse(0.0, 0.01 * viewScale, 0.14 * viewScale, 0.07 * viewScale);
        popMatrix();
    }
}

float absSqrt(float a, float plus) {
    return sqrt(abs(a) + plus) * (a > 0.0 ? 1.0 : -1.0);
}