class Multiplayer implements GameState {
    ButtonPos[] playingButtons = {
        new ButtonPos(Event.PAUSE, 0, 0.45, 0.0, 0.55, 0.1)
    };

    boolean paused;
    float timer;
    int lastSpawned;
    int sinceUfo;

    Multiplayer() {
        this.paused = false;
        this.timer = 0.0;
        this.lastSpawned = 0;
        this.sinceUfo = 0;
        activeButtons = this.playingButtons;
        viewScale = height * 0.6;
        angle = 0.0;
        earths.clear();
        earths.add(new Earth(0.5, 0.0));
        earths.add(new Earth(-0.5, 0.0));
        earths.get(0).rot = HALF_PI;
        earths.get(1).rot = -HALF_PI;
        meteors = new ArrayList<Meteor>();
        spawnRandom(); spawnRandom(); spawnRandom();
        spawnRandom(); spawnRandom(); spawnRandom();
        ufo = null;
        clearParticles();
    }

    void draw() {
        if (!paused) {
            timer += delta;
            int newSpawned = (int)timer / meteorTime[difficulty];
            if (lastSpawned != newSpawned) {
                lastSpawned = newSpawned;
                spawnRandom();
                spawnRandom();
                if (ufo == null) {
                    if (0.01 > random(1.0 / (float)(++this.sinceUfo))) {
                        this.sinceUfo = 0;
                        spawnUfo();
                    }
                }
            }

            int spins[] = getSplitSpin();
            earths.get(0).move(-spins[0]);
            earths.get(1).move(spins[1]);
            if (ufo != null) {
                PVector ufoGravity = getGravity(ufo.pos.x);
                ufo.move(ufoGravity);
                tryCollideEarth(ufo, ufo.pos.x < 0.0 ? 1 : 0, difficulty >= 3);
            }

            for (int m = 0; m < meteors.size();) {
                Meteor meteor = meteors.get(m);
                if (meteor.delete) {
                    meteors.remove(m);
                } else {
                    PVector gravity = getGravity(meteor.pos.x);
                    meteor.move(gravity);
                    tryCollideEarth(meteor, meteor.pos.x < 0.0 ? 1 : 0, true);
                    if (ufo != null) tryCollide(meteor, ufo);
                    m++;
                }
            }

            for (int m1 = 0; m1 < meteors.size() - 1; m1++) {
                Meteor meteor1 = meteors.get(m1);
                for (int m2 = m1 + 1; m2 < meteors.size(); m2++) {
                    Meteor meteor2 = meteors.get(m2);
                    if (meteor2.delete) continue;
                    //meteor1.bounceMeteor(meteor2);
                    tryCollide(meteor1, meteor2);
                    if (meteor1.delete) break;
                }
            }
            moveParticles();
        }

        drawParticles();
        earths.get(0).draw();
        earths.get(1).draw();
        if (ufo != null) ufo.draw();
        for (int m = 0; m < meteors.size(); m++) {
            meteors.get(m).draw();
        }
    }

    PVector getGravity(float x) {
        PVector left = earths.get(1).pos;
        PVector right = earths.get(0).pos;
        /*
        if (x < left.x) return left;
        else if (x > right.x) return right;
        else {
            x = (x < 0.0 ? -1.0 : 1.0) * sqrt(abs(x) / right.x) * right.x;
            return new PVector(x, 0.0);
        }
        */
        if (x < 0.0) return left;
        else return right;
    }

    void spawnRandom() {
        PVector pos = PVector.fromAngle(random(TWO_PI));
        pos.mult(random(2.0, 2.5));
        PVector vel = PVector.fromAngle(random(TWO_PI));
        vel.mult(random(3.0, 5.0));
        float size = random(0.05, 0.15);
        meteors.add(new Meteor(pos, vel, size));
    }
    
    void spawnUfo() {
        PVector pos = PVector.fromAngle(random(TWO_PI));
        pos.mult(random(1.0, 2.0));
        PVector vel = PVector.fromAngle(random(TWO_PI));
        vel.mult(random(3.0, 5.0));
        ufo = new Ufo(pos, vel);
    }

    void hud() {
       if (paused) {
           fill(0x00, 0x88);
           rect(width * -0.5, height * -0.5, width, height);
       }

       fill(0xff);
       rect(height * -0.05, height * -0.49, height * 0.03, height * 0.1);
       rect(height * 0.05, height * -0.49, height * -0.03, height * 0.1);

       int mins = (int)timer / 60;
       int secs = (int)timer % 60;
       String time = (mins < 10 ? "0" : "") + mins + ":" + (secs < 10 ? "0" : "") + secs;

       pushMatrix();
       rotate(HALF_PI);
       textAlign(RIGHT, TOP);
       textSize(height * 0.07);
       text(time, height * 0.45, width * 0.03);
       if (paused) {
           textAlign(CENTER, CENTER);
           textSize(height * 0.1);
           text("Paused", 0.0, width * 0.2);
       }
      
       rotate(PI);
       textAlign(LEFT, TOP);
       textSize(height * 0.07);
       text(time, height * -0.45, width * 0.03);
       if (paused) {
           textAlign(CENTER, CENTER);
           textSize(height * 0.1);
           text("Paused", 0.0, width * 0.2);
       }
       popMatrix();
    }

    void event(Event e, int param) {
        switch (e) {
            case PAUSE:
                paused = !paused;
                delta = 0.01;
                break;
            case GAME_OVER:
                gamestate = new GameOver(new PVector(0.0, height * 0.44), this.timer);
                break;
        }
    }

    void back() {
        this.paused = !paused;
        delta = 0.01;
    }
    
    boolean paused() {
        return this.paused;
    }
}
