interface Physics {
    PVector pos();
    PVector vel();
    float radius();
    float mass();
    void collision(Physics other, float speed, float massToOther, int which);
    void collideEarth(Earth e, float speed);
}

void tryCollide(Physics a, Physics b) {
    float dist = a.pos().dist(b.pos());
    float targetDist = a.radius() + b.radius();
    if (dist < targetDist) {
        PVector dirAtoB = PVector.sub(a.pos(), b.pos());
        dirAtoB.normalize();

        /*
        PVector velA = a.vel().copy();
        PVector velB = b.vel().copy();
        PVector velAvg = PVector.mult(PVector.add(velA, velB), 0.5);
        velA.sub(velAvg);
        velB.sub(velAvg);
        float velAtoB = -velA.dot(dirAtoB);
        float velBtoA = velB.dot(dirAtoB);
        float speed = velAtoB + velBtoA;
        */
        float velAtoB = -PVector.sub(a.vel(), b.vel()).dot(dirAtoB);
        float velBtoA = PVector.sub(b.vel(), a.vel()).dot(dirAtoB);
        float speed = (velAtoB + velBtoA) * 0.5;
        
        if (a.mass() != 0.0 && b.mass() != 0.0) {
            float offsetBy = (targetDist - dist) * min(speed, 1.0) * delta;
            //if (speed <= 0.0) offsetBy *= delta;

            PVector offset = PVector.mult(dirAtoB, offsetBy * 0.5);
            a.pos().sub(offset);
            b.pos().add(offset);

            //if (speed > 0.0) {
                float massAtoB = a.mass() / b.mass();
                float massBtoA = 1.0 / massAtoB;

                PVector bounce = PVector.mult(dirAtoB, max(speed, 0.1));
                a.vel().add(PVector.mult(bounce, min(massBtoA, 2.0) * 0.98));
                b.vel().sub(PVector.mult(bounce, min(massAtoB, 2.0) * 0.98));

                a.collision(b, speed, massAtoB, 0);
                b.collision(a, speed, massBtoA, 1);
            //}
        }
    }
}

void tryCollideEarth(Physics p, int e, boolean trampolines) {
    Earth earth = earths.get(e);
    PVector toEarth = PVector.sub(earth.pos, p.pos());
    float sizeHandicap = p.radius() * 0.4;
    if (trampolines) {
        for (int t = 0; t < 2; t++) {
            float angleTram = earth.trampolines[t] + earth.rot;
            PVector dirToTram = PVector.fromAngle(angleTram);
            PVector dirAlongTram = PVector.fromAngle(angleTram + HALF_PI);
            float dotToTram = toEarth.dot(dirToTram);
            float dotAlongTram = toEarth.dot(dirAlongTram);
            float distToTram = dotToTram - 0.10 - p.radius();
            float ratioAlong = dotAlongTram / (0.09 + sizeHandicap);
            boolean okAlong = abs(ratioAlong) <= 1.0;
            //boolean okAlong = abs(dotAlongTram) <= 0.09 + sizeHandicap;
            float meteorEdge = 
            boolean okTowards = distToTram >= -0.07 && distToTram < 0;
            if (okAlong && okTowards) {
                float angular = 0.07 * (float)earth.spin * -ratioAlong / physicsSpeed[difficulty];
                float speed = p.vel().dot(dirToTram) + angular;
                p.pos().add(PVector.mult(dirToTram, distToTram * min(speed, 1.0) * delta));
                if (speed > 0) {
                    earth.effectBounce(p, speed);
                    p.vel().add(PVector.mult(dirToTram, -1.96 * speed - 0.7));
                    return;
                }
            }
        }
            //this.okAlong |= okAlong;
            //this.okTowards |= okTowards;
    }

    float distToEarth = toEarth.mag() - p.radius() - 0.075;
    if (distToEarth < 0.0) {
        PVector dirToEarth = toEarth.copy();
        dirToEarth.normalize();

        float speed = p.vel().dot(dirToEarth);
        p.pos().add(PVector.mult(dirToEarth, distToEarth * min(speed, 1.0) * delta));
        if (speed > 0.0) {
            p.collideEarth(earth, speed);
                /*
                PVector bounce = toEarth.copy();
                bounce.setMag(-4.0 * speed);
                this.vel.add(bounce);
                PVector offset = dirToEarth.copy();
                offset.mult(distToEarth);
                this.pos.add(offset);
                //this.pos.setMag(0.075 + this.size / 2.0);
                */
            p.vel().add(PVector.mult(dirToEarth, -1.4 * speed - 0.6));
        }
    }
}