Particle particles[] = new Particle[128];
int particleIndex = 0;

class Particle {
    PVector pos, vel, col;
    float life;

    Particle(PVector pos, PVector vel, PVector col) {
        this.pos = pos;
        this.vel = vel;
        this.col = new PVector(col.x + random(0.2) - 0.1, col.y + random(0.2) - 0.1, col.z + random(0.2) - 0.1);
        this.life = random(0.5, 2.0);
    }

    void draw() {
        if (this.life <= 0.0) return;
        fill(this.col.x, this.col.y, this.col.z);
        ellipse(this.pos.x * viewScale, this.pos.y * viewScale, 0.02 * viewScale, 0.02 * viewScale);
    }

    void move() {
        if (this.life <= 0.0) return;
        this.life -= delta;
        PVector gravity = this.pos.copy();
        gravity.normalize();
        this.vel.sub(PVector.mult(gravity, 3.0 * delta));
        this.pos.add(PVector.mult(this.vel, physicsSpeed[difficulty] * delta));
    }
}

void clearParticles() {
    for (int p = 0; p < 128; p++) {
        particles[p] = null;
    }
}

void drawParticles() {
    for (int p = 0; p < 128; p++) {
        if (particles[p] != null) particles[p].draw();
    }
}

void moveParticles() {
    for (int p = 0; p < 128; p++) {
        if (particles[p] != null) particles[p].move();
    }
}

boolean particleExpired() {
    Particle old = particles[particleIndex];
    return old == null || old.life < 0.0 || old.life < 1.0 && old.life < random(1.0);
}

void circleParticles(PVector pos, PVector vel, float radius, int count, PVector col) {
    for (int p = 0; p < count; p++) {
        if (particleExpired()) {
            float a = random(TWO_PI);
            PVector rpos = PVector.fromAngle(a + random(-0.5, 0.5));
            rpos.mult(radius);
            PVector ppos = PVector.add(pos, rpos);
            PVector rvel = PVector.fromAngle(a);
            rvel.mult(random(1.0, 4.0));
            PVector pvel = PVector.add(vel, rvel);
            particles[particleIndex] = new Particle(ppos, pvel, col);
        }
        particleIndex = (particleIndex + 1) % 128;
    }
}

void fanParticles(PVector pos, PVector vel, float angle, int count, PVector col) {
    angle += HALF_PI;
    for (int p = 0; p < count; p++) {
        if (particleExpired()) {
            float a = random(0.8) - 0.4;
            PVector rvel = PVector.fromAngle(a);
            rvel.mult(random(0.3, 3.0) * (random(1.0) < 0.5 ? 1.0 : -1.0));
            PVector pvel = PVector.add(vel, rvel);
            particles[particleIndex] = new Particle(pos.copy(), pvel, col);
        }
        particleIndex = (particleIndex + 1) % 128;
    }
}