class Singleplayer implements GameState {
    ButtonPos[] playingButtons = {
        new ButtonPos(Event.PAUSE, 0, 0.45, 0.0, 0.55, 0.1)
    };

    boolean paused;
    float timer;
    int lastSpawned;
    int sinceUfo;

    Singleplayer() {
        this.paused = false;
        this.timer = 0.0;
        this.lastSpawned = 0;
        this.sinceUfo = 0;
        activeButtons = this.playingButtons;
        meteors = new ArrayList<Meteor>();
        spawnRandom(); spawnRandom(); spawnRandom();
        ufo = null;
        clearParticles();
    }

    void draw() {
        if (!paused) {
            timer += delta;
            int newSpawned = (int)timer / meteorTime[difficulty];
            if (lastSpawned != newSpawned) {
                lastSpawned = newSpawned;
                spawnRandom();
                if (ufo == null) {
                    if (0.01 > random(1.0 / (float)(++this.sinceUfo))) {
                        this.sinceUfo = 0;
                        spawnUfo();
                    }
                }
            }

            angle += (earths.get(0).rot - angle) * 2.0 * delta;
            earths.get(0).move(getSpin());
            
            if (ufo != null) {
                ufo.move(new PVector(0.0, 0.0));
                tryCollideEarth(ufo, 0, difficulty >= 3);
            }

            for (int m = 0; m < meteors.size();) {
                Meteor meteor = meteors.get(m);
                if (meteor.delete) {
                    meteors.remove(m);
                } else {
                    meteor.move(new PVector(0.0, 0.0));
                    tryCollideEarth(meteor, 0, true);
                    if (ufo != null) tryCollide(meteor, ufo);
                    m++;
                }
            }

            for (int m1 = 0; m1 < meteors.size() - 1; m1++) {
                Meteor meteor1 = meteors.get(m1);
                for (int m2 = m1 + 1; m2 < meteors.size(); m2++) {
                    Meteor meteor2 = meteors.get(m2);
                    if (meteor2.delete) continue;
                    //meteor1.bounceMeteor(meteor2);
                    tryCollide(meteor1, meteor2);
                    if (meteor1.delete) break;
                }
            }
            moveParticles();
        }

        drawParticles();
        earths.get(0).draw();
        if (ufo != null) ufo.draw();
        for (int m = 0; m < meteors.size(); m++) {
            meteors.get(m).draw();
        }
    }

    void spawnRandom() {
        PVector pos = PVector.fromAngle(random(TWO_PI));
        pos.mult(random(0.7, 1.7));
        PVector vel = PVector.fromAngle(random(TWO_PI));
        vel.mult(random(0.2, 3.0));
        float size = random(0.05, 0.15);
        meteors.add(new Meteor(pos, vel, size));
    }
    
    void spawnUfo() {
        PVector pos = PVector.fromAngle(random(TWO_PI));
        pos.mult(random(1.0, 2.0));
        PVector vel = PVector.fromAngle(random(TWO_PI));
        vel.mult(random(3.0, 5.0));
        ufo = new Ufo(pos, vel);
    }

    void hud() {
      if (paused) {
          fill(0x00, 0x88);
          rect(width * -0.5, height * -0.5, width, height);
          
          textAlign(CENTER, CENTER);
          textSize(width * 0.05);
          fill(0xff);
          text("Paused", 0.0, 0.0);
      }
      fill(0xff);
      rect(height * -0.05, height * -0.49, height * 0.03, height * 0.1);
      rect(height * 0.05, height * -0.49, height * -0.03, height * 0.1);
      
      textAlign(RIGHT, TOP);
      textSize(width * 0.05);
      fill(0xff);
      int mins = (int)timer / 60;
      int secs = (int)timer % 60;
      text((mins < 10 ? "0" : "") + mins + ":" + (secs < 10 ? "0" : "") + secs, width * 0.47, height * -0.45);
    }

    void event(Event e, int param) {
        switch (e) {
            case PAUSE:
                paused = !paused;
                delta = 0.01;
                break;
            case GAME_OVER:
                gamestate = new GameOver(new PVector(width * 0.46, height * -0.44), this.timer);
                break;
        }
    }

    void back() {
        this.paused = !paused;
        delta = 0.01;
    }
    
    boolean paused() {
        return this.paused;
    }
}
