class Meteor implements Physics {
    PVector pos, vel;
    float rot, spin;
    float size, invuln, cracks;
    boolean delete;
    //boolean okTowards, okAlong;

    Meteor(float x, float y, float vx, float vy, float spin, float size) {
        pos = new PVector(x, y);
        vel = new PVector(vx, vy);
        new Meteor(pos, vel, size);
    }
    Meteor(PVector pos, PVector vel, float size) {
        this.pos = pos;
        this.vel = vel;
        this.rot = 0;
        this.spin = random(10.0) - 5.0;
        this.size = size;
        this.invuln = 0.25;
        this.cracks = 0.0;
        this.delete = false;
    }
    
    PVector pos() {
        return this.pos;
    }
    PVector vel() {
        return this.vel;
    }
    float radius() {
        return this.size / 2.0;
    }
    float mass() {
        return pow(this.size, 1.5);
    }
    void collision(Physics other, float speed, float massToOther, int which) {
        if (this.delete) return;
        float speedMin = speed - 1.0;
        if (speedMin <= 0.0) return;

        try {
            Meteor otherMet = (Meteor)other;

            if (which == 0 && otherMet.invuln <= 0.0 && this.invuln <= 0.0) {
                float addCracksA = (speedMin * this.size / otherMet.size) * combineChances[difficulty];
                this.cracks += random(addCracksA);
                float addCracksB = (speedMin * otherMet.size / this.size) * combineChances[difficulty];
                otherMet.cracks += random(addCracksB);
                float particleCount = ((this.size + otherMet.size) * 6.0 * sqrt(speedMin));

                float sumCracks = sqrt(pow(this.cracks, 2.0) + pow(otherMet.cracks, 2.0));
                float combineChance = (addCracksA + addCracksB) + sumCracks * 0.2;
                if (combineChance > random(1.0)) {
                    otherMet.delete = true;
                    this.delete = false;
                    this.pos = PVector.div(PVector.add(PVector.mult(this.pos, this.size), PVector.mult(otherMet.pos, otherMet.size)), this.size + otherMet.size);
                    this.vel = PVector.div(PVector.add(PVector.mult(this.vel, this.size), PVector.mult(otherMet.vel, otherMet.size)), this.size + otherMet.size);
                    this.size = sqrt(pow(this.size, 2.0) + pow(otherMet.size, 2.0));
                    this.cracks = sumCracks;
                    circleParticles(this.pos, this.vel, this.radius(), (int)(particleCount * 1.5), new PVector(0x88, 0x66, 0x44));

                } else {
                    PVector avgPos = PVector.mult(PVector.add(this.pos, otherMet.pos), 0.5);
                    PVector avgVel = PVector.mult(PVector.add(this.vel, otherMet.vel), 0.5);
                    fanParticles(avgPos, avgVel, -PVector.sub(this.pos, otherMet.pos).heading(), (int)particleCount, new PVector(0x88, 0x66, 0x44));
                }
            }
        } catch (Exception e) {}

        if (this.invuln <= 0.0 && this.cracks > 1.0) this.explode();
        this.invuln = 0.25;
    }
    void collideEarth(Earth e, float speed) {
        e.hit(this, speed);
    }

    void draw() {
        if (this.delete) return;
        /*
        fill(this.okAlong ? 0xff : 0x00, this.okTowards ? 0xff : 0x00, 0x00);
        ellipse(this.pos.x * viewScale, this.pos.y * viewScale, (size + 0.05) * viewScale, (size + 0.05) * viewScale);
        */
        pushMatrix();
        translate(this.pos.x * viewScale, this.pos.y * viewScale);
        fill(0x88, 0x66 * (1.0 - pow(this.cracks, 2.0)), 0x44 * (1.0 - pow(this.cracks, 2.0)));
        ellipse(0.0, 0.0, this.size * viewScale, this.size * viewScale);
        
        if (gamestate.paused()) {
            stroke(0xff);
            line(0.0, 0.0, this.vel.x * viewScale * 0.1, this.vel.y * viewScale * 0.1);
            noStroke();
        }
        /*
        fill(0xff);
        textAlign(CENTER, CENTER);
        text((int)round(this.vel.mag() * 10.0), this.pos.x * viewScale, this.pos.y * viewScale);
        */
        popMatrix();
    }

    void move(PVector gravity) {
        if (this.invuln > 0.0) invuln -= delta;

        PVector accel = PVector.sub(gravity, this.pos);
        accel.setMag(3.0 * delta);
        this.vel.add(accel);
        if (this.vel.mag() > 10.0) {
            this.vel.mult(0.99);
        }

        this.pos.add(PVector.mult(this.vel, physicsSpeed[difficulty] * delta));
    }

    /*
    void bounceMeteor(Meteor other) {
        float dist = this.pos.dist(other.pos);
        float targetDist = (this.size + other.size) * 0.5;
        if (dist < targetDist) {
            PVector pos1to2 = PVector.sub(this.pos, other.pos);
            pos1to2.normalize();

            PVector vel1 = this.vel.copy();
            PVector vel2 = other.vel.copy();
            PVector velAvg = PVector.mult(PVector.add(vel1, vel2), 0.5);
            vel1.sub(velAvg);
            vel2.sub(velAvg);
            float vel1to2 = -vel1.dot(pos1to2);
            float vel2to1 = vel2.dot(pos1to2);
            float speed = vel1to2 + vel2to1;
            if (speed <= 0.0) return;

            float massRatio = this.size / other.size;
            massRatio = max(massRatio, 1.0 / massRatio);
            float massCombine = sqrt(massRatio * 10.0) / 30.0;
            float cracksCombine = sqrt((this.cracks + other.cracks) * 100.0) / 100.0;

            //addText("S" + (int)(speed * 100.0) + " * M" + (int)(massRatio * 100.0), this.pos);

            float combineChance = massCombine * max(speed - 0.5, 0.0);
            //println(combineChance + " = " + (1.0 - min(massRatio, 1.0 / massRatio)) + " + " + speed * 0.05);
      
            if (this.invuln <= 0.0 && other.invuln <= 0.0 && combineChance + cracksCombine > random(7.0)) {
                other.delete = true;
                this.delete = false;
                this.pos = PVector.div(PVector.add(PVector.mult(this.pos, this.size), PVector.mult(other.pos, other.size)), this.size + other.size);
                this.vel = PVector.div(PVector.add(PVector.mult(this.vel, this.size), PVector.mult(other.vel, other.size)), this.size + other.size);
                this.size = sqrt(pow(this.size, 2.0) + pow(other.size, 2.0));
                \*
                if (!this.massive && this.size >= 0.5) {
                    this.massive = true;
                    massiveMeteors.add(this);
                }
                *\

                this.cracks += other.cracks + random(sqrt(combineChance) * 0.03);
                this.invuln = 0.25;

            } else {
                this.cracks += random(sqrt(combineChance) * 0.03 * sqrt(this.size / other.size));
                other.cracks += random(sqrt(combineChance) * 0.03 * sqrt(other.size / this.size));

                PVector bounce = PVector.mult(pos1to2, speed);
                this.vel.add(PVector.mult(bounce, min(other.size / this.size, 2.0) * 0.98));
                other.vel.sub(PVector.mult(bounce, min(this.size / other.size, 2.0) * 0.98));
                PVector offset = PVector.mult(pos1to2, (targetDist - dist) * 0.5);
                this.pos.add(offset);
                other.pos.sub(offset);

                \*
                stroke(0x00, 0xff, 0x00);
                line(this.pos.x * height, this.pos.y * height, (this.pos.x + bounce.x) * height, (this.pos.y + bounce.y) * height);
                line(other.pos.x * height, other.pos.y * height, (other.pos.x - bounce.x) * height, (other.pos.y - bounce.y) * height);
                *\
            }

            if (this.cracks > 1.0) this.explode();
            if (other.cracks > 1.0) other.explode();
        }
    }
    */

    void explode() {
        if (this.delete) return;
        circleParticles(this.pos, this.vel, this.radius(), (int)(this.size * 50.0), new PVector(0x88, 0x66, 0x44));
        float breakSpeed = this.size * 0.5;
        float toBreak = pow(this.size, 2.0) * explodeMults[difficulty];
        println("Breaking at mass " + toBreak);
        while (toBreak >= 0.005) {
            float broken = min(random(0.005, 0.015 + toBreak * 0.2), toBreak);
            toBreak -= broken;
            println("Breaking off " + broken);
            float brokenSize = sqrt(broken);

            float aPos = random(TWO_PI);
            float aVel = aPos + random(-0.1, 0.1);
            PVector nextPos = PVector.add(this.pos, PVector.mult(PVector.fromAngle(aPos), brokenSize * 0.3));
            PVector nextVel = PVector.add(this.vel, PVector.mult(PVector.fromAngle(aPos + aVel), random(1.0, 5.0 + breakSpeed)));

            Meteor newMeteor = new Meteor(nextPos, nextVel, brokenSize);
            meteors.add(newMeteor);
        }
        this.delete = true;
        /*
        } else {
            float aPos = random(TWO_PI);
            float aVel = aPos + random(-0.1, 0.1);
            this.pos.add(PVector.mult(PVector.fromAngle(aPos), this.size * 0.5));
            this.vel.add(PVector.mult(PVector.fromAngle(aPos + aVel), random(0.5, 5.0)));
            this.cracks = 0.0;
        }
        */
    }
}
