class MainMenu implements GameState {
    float fadeOut = 0.0;
    int selectedGame = -1;

    ButtonPos[] menuButtons = {
        new ButtonPos(Event.MENU_SELECT, 0, 0.0, 0.7, 0.5, 1.0),
        new ButtonPos(Event.MENU_SELECT, 1, 0.5, 0.7, 1.0, 1.0),
        new ButtonPos(Event.MENU_SELECT, 2, 0.7, 0.0, 1.0, 0.3)
    };

    MainMenu() {
        earths.clear();
        earths.add(new Earth(0.0, 0.0));
        activeButtons = this.menuButtons;
    }

    void draw() {
        angle += (earths.get(0).rot - angle) * 2.0 * delta;
        earths.get(0).move(getSpin());
        earths.get(0).draw();
    }

    void hud() {
        float textPos = this.fadeOut * 0.2;
        float selectedPos = (-this.fadeOut + pow(this.fadeOut, 3) * 2.0) * 0.2;
    
        textAlign(CENTER, TOP);
        textSize(width * 0.05);
        fill(0xff);
        text("Bounce-a-Meteor 2", 0, height * -(0.45 + textPos));

        textAlign(RIGHT, BOTTOM);
        text("Singleplayer", width * -0.1, height * (0.45 + (this.selectedGame == 0 ? selectedPos : textPos)));
        textAlign(LEFT, BOTTOM);
        text("Multiplayer", width * 0.1, height * (0.45 + (this.selectedGame == 1 ? selectedPos : textPos)));
        
        textSize(width * 0.04);
        textAlign(RIGHT, CENTER);
        text("Difficulty:\n" + diffNames[difficulty], width * (0.48 + textPos), height * -0.35);

        if (this.selectedGame != -1) {
            this.fadeOut = lerpDelta(this.fadeOut, 1.2, 1.5); 
        }
        if (this.fadeOut >= 1.0) {
            if (this.selectedGame == 0) {
                gamestate = new Singleplayer();
            } else {
                gamestate = new Multiplayer();
            }
        }
    }

    void event(Event e, int param) {
        if (e == Event.MENU_SELECT && this.selectedGame == -1) {
            switch (param) {
                case 0:
                case 1:
                    this.selectedGame = param;
                    break;
                case 2:
                    difficulty = (difficulty + 1) % 4;
                    break;
            }
        }
    }

    void back() {
    }
    
    boolean paused() {
        return false;
    }
}