//import android.net.Network;

GameState gamestate;
int difficulty = 1;
ArrayList<Earth> earths = new ArrayList<Earth>(2);
ArrayList<Meteor> meteors;
Ufo ufo;
float angle, shake = 0.0;
float delta = 0.05;
float viewScale;
PVector stars[] = new PVector[4 * 4];


void setup() {
    viewScale = height * 0.7;
    //inworldTexts = new ArrayList<InWorldText>();
    size(displayWidth, displayHeight, P2D);
    gamestate = new MainMenu();
    for (int i = 0; i < 4 * 4; i++) {
        float x = (float)(i % 4) - 1.5 + random(1.0) - 0.5;
        float y = (float)(i / 4) - 1.5 + random(1.0) - 0.5;
        stars[i] = new PVector(x * 0.35, y * 0.35);
    }
}


void draw() {
    delta = ((1.0 / frameRate) + delta) * 0.5;

    translate(width * 0.5, height * 0.5);
    background(0x1f, 0x1e, 0x33);

    pushMatrix();
    rotate(-angle);
    noFill();
    stroke(0xff);
    
    PVector bounce = PVector.mult(earths.get(0).effectPos, viewScale * 0.5);
    for (int i = 0; i < 4 * 4; i++) {
        PVector star = PVector.mult(stars[i], height);
        ellipse(star.x + bounce.x, star.y + bounce.y, 10, 10);
    }
    noStroke();

    stroke(0xff);
    gamestate.draw();


    popMatrix();

    gamestate.hud();
    
    textSize(height * 0.03);
    textAlign(TOP, LEFT);
    text(delta, width * -0.5 + 20, height * -0.5 + 60);
}


float lerpDelta(float a, float b, float c) {
    float to = b - a;
    return a + to * c * delta;
}


interface GameState {
    void draw();
    void hud();
    void event(Event e, int param);
    void back();
    boolean paused();
}
