class GameOver implements GameState {
    ButtonPos[] gameoverButtons = {
        new ButtonPos(Event.MENU_SELECT, 0, 0.0, 0.0, 1.0, 1.0)
    };

    PVector textPos;
    String timer;
    float timeInGameover;
    PVector gravity;

    GameOver(PVector textPos, float timer) {
        this.textPos = textPos;
        int mins = (int)timer / 60;
        int secs = (int)timer % 60;
        this.timer = (mins < 10 ? "0" : "") + mins + ":" + (secs < 10 ? "0" : "") + secs;
        this.timeInGameover = 0.0;
        
        Earth survivingEarth = null;
        Earth e1 = earths.get(0);
        Earth e2 = earths.size() == 2 ? earths.get(1) : null;
        if (e1.life > 0.0) survivingEarth = e1;
        else if (e2 != null && e2.life > 0.0) survivingEarth = e2;
        this.gravity = survivingEarth != null ? survivingEarth.pos : new PVector(0.0, 0.0);
        activeButtons = this.gameoverButtons;
    }

    void draw() {
        this.timeInGameover += delta;

        for (int e = 0; e < earths.size(); e++) {
            Earth earth = earths.get(e);
            if (earth.life > 0.0) {
                earth.draw();
            }
        }
        if (ufo != null) {
            ufo.move(this.gravity);
            ufo.draw();
        }

        for (int m = 0; m < meteors.size();) {
            Meteor meteor = meteors.get(m);
            if (meteor.delete) {
                meteors.remove(m);
            } else {
                meteor.move(this.gravity);
                if (ufo != null) tryCollide(meteor, ufo);
                m++;
            }
        }

        for (int m1 = 0; m1 < meteors.size() - 1; m1++) {
            Meteor meteor1 = meteors.get(m1);
            for (int m2 = m1 + 1; m2 < meteors.size(); m2++) {
                Meteor meteor2 = meteors.get(m2);
                if (meteor2.delete) continue;
                //meteor1.bounceMeteor(meteor2);
                tryCollide(meteor1, meteor2);
                if (meteor1.delete) break;
            }
        }
        moveParticles();

        drawParticles();
        for (int m = 0; m < meteors.size(); m++) {
            meteors.get(m).draw();
        }
    }

    void hud() {
      textAlign(CENTER, CENTER);
      textSize(width * 0.07);
      fill(0xff);
      
      text(timer, this.textPos.x, this.textPos.y);
      float mag = lerpDelta(this.textPos.mag(), 0.0, 1.0);
      this.textPos.setMag(mag);
    }

    void event(Event e, int param) {
        switch (e) {
            case MENU_SELECT:
                if (timeInGameover <= 0.5) return;
                gamestate = new MainMenu();
                break;
        }
    }

    void back() {
    }
    
    boolean paused() {
        return false;
    }
}
