PVector earthNormal = new PVector(0x00, 0xff, 0x00);
PVector earthHealed = new PVector(0x0f, 0x7f, 0xff);
PVector earthDead = new PVector(0x88, 0x66, 0x44);

class Earth {
    float life;
    float rot;
    int spin;
    float[] trampolines;
    PVector pos;
    PVector effectPos, effectVel;

    Earth(float x, float y) {
        this.life = 1.0;
        this.rot = angle;
        this.spin = 0;
        this.trampolines = new float[2];
        this.trampolines[0] = 0.0;
        this.trampolines[1] = PI;
        this.pos = new PVector(x, y);
        this.effectPos = new PVector(0.0, 0.0);
        this.effectVel = new PVector(0.0, 0.0);
    }

    void draw() {
        if (!gamestate.paused()) {
            this.effectVel.sub(PVector.mult(this.effectPos, 8.0 * delta));
            this.effectPos.mult(0.97);
            this.effectPos.add(PVector.mult(this.effectVel, 6.0 * delta));
            this.effectVel.mult(0.95);
        }

        pushMatrix();
        translate((this.pos.x - this.effectPos.x) * viewScale, (this.pos.y - this.effectPos.y) * viewScale);
        
        PVector earthColour = earthNormal.copy();
        if (this.life <= 1.0) {
            earthColour.lerp(earthDead, 1.0 - this.life);
        } else {
            earthColour.lerp(earthHealed, this.life - 1.0);
        }
        fill(earthColour.x, earthColour.y, earthColour.z);
        ellipse(0.0, 0.0, viewScale * 0.15, viewScale * 0.15);
        fill(0xff, 0x88, 0x00);

        for (int t = 0; t < 2; t++) {
            pushMatrix();
            rotate(this.rot + this.trampolines[t]);
            rect(viewScale * -0.11, viewScale * -0.075, viewScale * 0.03, viewScale * 0.15);
            popMatrix();
        }
        popMatrix();
    }

    void move(int spin) {
        if (this.life <= 1.0) {
            this.life = min(this.life + delta * 0.003, 1.0);
            this.trampolines[0] = this.trampolines[0] * (1.0 - 0.02 * delta);
            this.trampolines[1] = PI + (this.trampolines[1] - PI) * (1.0 - 0.02 * delta);
        }
        this.spin = spin;
        this.rot += spin * 2.0 * delta;
    }

    void effectBounce(Physics p, float speed) {
        PVector bounce = p.pos().copy();
        bounce.setMag(5.0);
        bounce.sub(p.vel());
        bounce.setMag(sqrt(p.mass() * speed * 3.0) * 0.03);
        this.effectVel.add(bounce);
    }

    void hit(Meteor meteor, float speed) {
        if (life <= 0.0) return;
        PVector toMet = PVector.sub(meteor.pos, this.pos);
        toMet.setMag(0.075);
        fanParticles(PVector.add(this.pos, toMet), PVector.mult(meteor.vel, -0.35), toMet.heading(), (int)(meteor.size * 15.0 * sqrt(speed)), new PVector(0x88, 0x66, 0x44));

        this.effectBounce(meteor, speed);
        this.trampolines[0] += random(-1.0, 1.0) * trampolineShift[difficulty];
        this.trampolines[1] += random(-1.0, 1.0) * trampolineShift[difficulty];
        this.life -= speed * sqrt(meteor.size) * 0.08;
        if (this.life <= 0.0) {
            this.explode();
            gamestate.event(Event.GAME_OVER, 0);
        }
    }

    void explode() {
        //circleParticles(this.pos, this.effectVel, 0.075, 32, new PVector(0x88, 0x66, 0x44));
        Meteor explodedEarth = new Meteor(PVector.add(this.pos, this.effectPos), PVector.mult(this.effectVel, 2.0), 0.3);
        explodedEarth.vel.mult(10.0);
        explodedEarth.explode();
        //meteors.add(explodedEarth);
    }
}