// If just pressed a button, ignore touch 0 for controls
boolean pressedButton = false;
ButtonPos[] activeButtons = null;


enum Event {
    MENU_SELECT,
    GAME_OVER,
    PAUSE,
    QUIT,
}


class ButtonPos {
    PVector c1, c2;
    Event e;
    int param;
    
    ButtonPos(Event e, int param, float x1, float y1, float x2, float y2) {
        this.c1 = new PVector(x1, y1);
        this.c2 = new PVector(x2, y2);
        this.e = e;
        this.param = param;
    }

    boolean inside(float x, float y) {
        PVector p = new PVector(x / width, y / height);
        return p.x > min(this.c1.x, this.c2.x) &&
               p.x < max(this.c1.x, this.c2.x) &&
               p.y > min(this.c1.y, this.c2.y) &&
               p.y < max(this.c1.y, this.c2.y);
    }
}


// Buttons will only work if no other taps pressed
void mousePressed() {
    if (activeButtons != null) {
        for (int b = 0; b < activeButtons.length; b++) {
            if (activeButtons[b].inside(mouseX, mouseY)) {
                pressedButton = true;
                gamestate.event(activeButtons[b].e, activeButtons[b].param);
                return;
            }
        }
    }
}


void mouseReleased() {
    pressedButton = false;
}

void touchEnded() {
    if (touches.length == 0) {
        pressedButton = false;
    }
}

void backPressed() {
    gamestate.back();
}


int getSpin() {
    int sum = 0;
    for (int t = pressedButton ? 1 : 0; t < touches.length; t++) {
        if (touches[t].x > width * 0.55) {
            sum++;
        } else if (touches[t].x < width * 0.45) {
            sum--;
        }
    }
    return sum > 0 ? 1 : sum < 0 ? -1 : 0;
}

int[] getSplitSpin() {
    int sums[] = { 0, 0 };
    for (int t = pressedButton ? 1 : 0; t < touches.length; t++) {
        int player;
        if (touches[t].x > width * 0.55) {
            player = 0;
        } else if (touches[t].x < width * 0.45) {
            player = 1;
        } else {
            continue;
        }
 
        if (touches[t].y > height * 0.55) {
            sums[player]++;
        } else if (touches[t].y < height * 0.45) {
            sums[player]--;
        }
    }

    int spins[] = { 0, 0 };
    for (int s = 0; s < 2; s++) {
        spins[s] = sums[s] > 0 ? 1 : sums[s] < 0 ? -1 : 0;
    }
    return spins;
}