// Scrapped feature - UFO would shoot bullets occasionally to protect itself
// from getting slammed.

Bullet bullets[] = new Bullet[128];
int bulletIndex = 0;

class Bullet implements Physics {
    PVector pos, vel;
    float life, spin;

    Bullet(PVector pos, PVector vel) {
        this.pos = pos;
        this.vel = vel;
        this.life = 2.0;
        this.spin = random(-2.0, 2.0);
    }

    PVector pos() {
        return this.pos;
    }
    PVector vel() {
        return this.vel;
    }
    float radius() {
        return 0.02;
    }
    float mass() {
        return 0.0;
    }
    void collision(Physics other, float speed, float massToOther, int which) {
        try {
            Meteor meteor = (Meteor)other;
            
            meteor.cracks += 0.01 / meteor.mass();
            if (meteor.cracks > 1.0) meteor.explode();
        } catch (Exception e) {}
        
        this.life = 0.0;
    }
    void collideEarth(Earth e, float speed) {
        this.life = 0.0;
    }
}